#ifndef _fms_state_h_
#define _fms_state_h_

/*
 * Defines for fms state
 */

enum fms_state_code {
  FMS_STATE_IDLE,
  FMS_STATE_GET_MAP,
  FMS_STATE_SEND_MAP,
  FMS_STATE_RESOLVING,
  FMS_STATE_VERIFYING,
  FMS_STATE_QUIET,
  FMS_STATE_NUM_STATES
};

enum fms_state_change {
  FMS_STATE_LINK_CHANGE,
  FMS_STATE_FABRIC_CHANGE,
  FMS_STATE_QUAD_DIS_CHANGE
};

/*
 * Struct with state-related variables
 */
struct fms_state {
  enum fms_state_code state;
};


/*
 * prototypes
 */
void fms_state_map_sent(void);
void fms_state_fabric_resolution_complete(void);
void fms_state_fabric_changed(enum fms_state_change what_changed);
void fms_state_map_is_invalid(struct fms_fma_desc *);

#endif
